package com.metapace.printer.sample;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioGroup;
import android.widget.Toast;

import com.metapace.thermalprinter.MetapacePrinter;

public class PageModeActivity extends Activity implements OnClickListener {
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_page_mode);

		Button button = (Button) findViewById(R.id.button1);
		button.setOnClickListener(this);
		button = (Button) findViewById(R.id.button2);
		button.setOnClickListener(this);
	}

	@Override
	public void onClick(View v) {
		switch (v.getId()) {
		case R.id.button1:
			setPageMode();
			break;

		case R.id.button2:
			printSample();
			break;
		}
	}

	private void setPageMode() {
		RadioGroup radioGroup = (RadioGroup) findViewById(R.id.radioGroup1);
		if (radioGroup.getCheckedRadioButtonId() == R.id.radio0) {
			MainActivity.metapacePrinter.setStandardMode();
		} else {
			MainActivity.metapacePrinter.setPageMode();

			radioGroup = (RadioGroup) findViewById(R.id.radioGroup2);
			switch (radioGroup.getCheckedRadioButtonId()) {
			case R.id.radio2:
				MainActivity.metapacePrinter.setPrintDirection(MetapacePrinter.DIRECTION_0_DEGREE_ROTATION);
				break;
			case R.id.radio3:
				MainActivity.metapacePrinter.setPrintDirection(MetapacePrinter.DIRECTION_90_DEGREE_ROTATION);
				break;
			case R.id.radio4:
				MainActivity.metapacePrinter.setPrintDirection(MetapacePrinter.DIRECTION_180_DEGREE_ROTATION);
				break;
			case R.id.radio5:
				MainActivity.metapacePrinter.setPrintDirection(MetapacePrinter.DIRECTION_270_DEGREE_ROTATION);
				break;
			}

			EditText editText = (EditText) findViewById(R.id.editText1);
			String string = editText.getText().toString();
			if (string.length() == 0) {
				Toast.makeText(getApplicationContext(), "Please enter the horizontal start position again", Toast.LENGTH_SHORT).show();
				return;
			}
			int x = Integer.parseInt(string);

			editText = (EditText) findViewById(R.id.editText2);
			string = editText.getText().toString();
			if (string.length() == 0) {
				Toast.makeText(getApplicationContext(), "Please enter the vertical start position again", Toast.LENGTH_SHORT).show();
				return;
			}
			int y = Integer.parseInt(string);

			editText = (EditText) findViewById(R.id.editText3);
			string = editText.getText().toString();
			if (string.length() == 0) {
				Toast.makeText(getApplicationContext(), "Please enter the horizontal print area again", Toast.LENGTH_SHORT).show();
				return;
			}
			int width = Integer.parseInt(string);

			editText = (EditText) findViewById(R.id.editText4);
			string = editText.getText().toString();
			if (string.length() == 0) {
				Toast.makeText(getApplicationContext(), "Please enter the vertical print area again", Toast.LENGTH_SHORT).show();
				return;
			}
			int height = Integer.parseInt(string);

			MainActivity.metapacePrinter.setPrintArea(x, y, width, height);
		}
	}

	private void printSample() {
		MainActivity.metapacePrinter.setPageMode();
		MainActivity.metapacePrinter.setPrintDirection(MetapacePrinter.DIRECTION_180_DEGREE_ROTATION);
		MainActivity.metapacePrinter.setAbsoluteVerticalPrintPosition(0);
		MainActivity.metapacePrinter.setAbsolutePrintPosition(0);
		MainActivity.metapacePrinter.printText("Page mode\nsample",
				MetapacePrinter.ALIGNMENT_LEFT, MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
				MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
		MainActivity.metapacePrinter.setAbsoluteVerticalPrintPosition(0);
		MainActivity.metapacePrinter.setAbsolutePrintPosition(128);

		BitmapDrawable drawable = (BitmapDrawable) getResources().getDrawable(R.drawable.logo);
		Bitmap bitmap = drawable.getBitmap(); 
		MainActivity.metapacePrinter.printBitmap(bitmap, MetapacePrinter.ALIGNMENT_LEFT, 128, 70, false);
		MainActivity.metapacePrinter.setAbsoluteVerticalPrintPosition(0);
		MainActivity.metapacePrinter.setAbsolutePrintPosition(256);
		MainActivity.metapacePrinter.printQrCode("www.metapace.com", MetapacePrinter.ALIGNMENT_LEFT, MetapacePrinter.QR_CODE_MODEL2, 4, false);
		MainActivity.metapacePrinter.formFeed(true);
	}
}
